---@author Timers 2025
---Just a demonstration tool so the devs can see the Bukkake textures on the character.
---Might turn into an actual feature but needs a little bit of refactoring and a proper implemetation
---on ZomboWin.

--This values are really temporary just for this demo. Just the fact they are global its killing me.
--INCLUDING THE FUNCTIONS! EVERYTHING IS SUBJECT TO CHANGE!
ZomboWinBukkakeStatic = false
ZomboWinBukkakeSection = 0
ZomboWinBukkakeIndex = 0

--This main value determines how many layers of Bukkake we have,
--so if we had 21 items for each bodypart we would put 21 here.
--Currently there are 20 png images for each body part
local layersNum = 20

--There are many ways you can call the location through the functions
--as the formating is handled automaticaly to reduce errors.
--CHOOSE YOU POISON!
--Note: cette location doit correspondre au champ BodyLocation des fichiers se trouvant ici
-- ...\Zomboid\mods\ZomboWin AddOn\media\scripts\clothing\xxx.txt
--Also if you add any location in here, add it in resetBukkake() too, and make sure the naming is correct.
local bukkake_locations = {
	"Bukkake_FullBack",
	"Bukkake_CenteredBreast",
	"Bukkake_CenteredButt",
	"Bukkake_FullChest",
	"Bukkake_FullFace",
	"Bukkake_UpperLegs",
	"Bukkake_Miscellaneous",
	"Bukkake_CenteredMouth",
	"Bukkake_CenteredPussy",
	"Bukkake_UpperThigh"
}

---The main table holding everything together.
---@param playerTable: KahluaTable
function resetBukkake(playerTable)
	--In here this table contains data to acess each layer.
	--If you compare the current locations in here, you'll notice that each
	--layer must have the main location as its name. For example:
	--	FullFace has its name because of the Bukkake_FullFaceX location.
	--Note: Donc le nom du layer avant le = doit reprendre la partie après Bukkake_ du champ BodyLocation
	--
	--Note extrêmement importante: Il ne faut PAS mettre une numérotation comportant un 0x (càd 01 02 03 etc)
	--Exemple: il ne faut PAS mettre Bukkake_FullBack03 car le jeu cherchera à ajouter +1 (voir ZomboWinBukkakeSection et ZomboWinBukkakeIndex) à 03
	--ce qui ne donnera pas un calcul de sortie = à 04 mais une sortie = à 4
	--si on note tout les fichiers avec des 0x (donc par exemple Bukkake_FullBack03) le jeu cherchera un fichier Bukkake_FullBack4 et il ne trouvera rien
	--car on aura seulement un fichier Bukkake_FullBack04 dans les répertoires
	--ça donnera un code d'erreur comme quoi getBodyLocation n'a pas de table (Null)
	--
	--The FIRST value stores the ammount of fluid that each layer has,
	--and the SECOND just points to the main name of the items.
	playerTable.semenLevels = {
		FullBack = {0, "Bukkake_Back"},
		CenteredBreast = {0, "Bukkake_Breast"},
		CenteredButt = {0, "Bukkake_Butt"},
		FullChest = {0, "Bukkake_Chest"},
		FullFace = {0, "Bukkake_Face"},
		UpperLegs = {0, "Bukkake_Legs"},
		Miscellaneous = {0, "Bukkake_Misc"},
		CenteredMouth = {0, "Bukkake_Mouth"},
		CenteredPussy = {0, "Bukkake_Pussy"},
		UpperThigh = {0, "Bukkake_Thigh"}
	}
end

local function addPlayerBadText(player, text)
	HaloTextHelper.addText(player, text, HaloTextHelper.getColorRed());
end

local function addPlayerGoodText(player, text)
	HaloTextHelper.addText(player, text, HaloTextHelper.getColorGreen());
end

local function addPlayerWhiteText(player, text)
	HaloTextHelper.addText(player, text, HaloTextHelper.getColorWhite());
end

---@params locationText: string; Formats the given text to a proper Bukkake location.
local function formatBukkake(locationText)
	return string.gsub(string.gsub(locationText, "Bukkake_", ""), "%d", "")
end

local function testFunction(key)
	local player = getPlayer()
	if not player then return end

	--You can check https://pzwiki.net/wiki/Keyboard for the codes if you're confused.

	local left_key = 51		-- <		Adds values to the Bukkake system.
	local right_key = 52 	-- >		Subtracs values to the Bukkake system.

	local change_lkey = 26  -- [		Changes the location focus
	local change_rkey = 27 	-- ]		the same as above but on the other directions

	local switch_mode = 184 -- RAlt		Switches modes.
	local rcontrol_key = 157-- RCtrl 	Resets the Bukkake.

	--Checks in what mode it is, the Dynamic being the top, and Static the bottom.
	if not ZomboWinBukkakeStatic then
		--DYNAMIC MODE
		if left_key == key then
			removeCum(player, bukkake_locations[ZomboWinBukkakeSection + 1])
		elseif right_key == key then
			addCum(player, bukkake_locations[ZomboWinBukkakeSection + 1])
		elseif change_lkey == key then
			ZomboWinBukkakeSection = ((ZomboWinBukkakeSection - 1) + layersNum) % #bukkake_locations
			addPlayerWhiteText(player, formatBukkake(bukkake_locations[ZomboWinBukkakeSection + 1]))
		elseif change_rkey == key then
			ZomboWinBukkakeSection = (ZomboWinBukkakeSection + 1) % #bukkake_locations
			addPlayerWhiteText(player, formatBukkake(bukkake_locations[ZomboWinBukkakeSection + 1]))
		elseif rcontrol_key == key then
			playerTable = player:getTable()
			resetBukkake(playerTable)

			addPlayerBadText(player, "BUKKAKE RESETED!")
			checkBukkake(player)
		elseif switch_mode == key then
			playerTable = player:getTable()
			resetBukkake(playerTable)
			checkBukkake(player)

			ZomboWinBukkakeStatic = not ZomboWinBukkakeStatic

			addPlayerGoodText(player, "STATIC MODE: ACTIVATED")
			print("STATIC MODE:")
			print(ZomboWinBukkakeStatic)
		end
	else
		--STATIC MODE
		if left_key == key then
			ZomboWinBukkakeIndex = ((ZomboWinBukkakeIndex - 1) + layersNum + 1) % (layersNum + 1)
			selectBukkake(player, bukkake_locations[ZomboWinBukkakeSection + 1], ZomboWinBukkakeIndex)
		elseif right_key == key then
			ZomboWinBukkakeIndex = (ZomboWinBukkakeIndex + 1) % (layersNum + 1)
			selectBukkake(player, bukkake_locations[ZomboWinBukkakeSection + 1], ZomboWinBukkakeIndex)
		elseif change_lkey == key then
			ZomboWinBukkakeSection = ((ZomboWinBukkakeSection - 1) + layersNum) % #bukkake_locations
			addPlayerWhiteText(player, formatBukkake(bukkake_locations[ZomboWinBukkakeSection + 1]))
		elseif change_rkey == key then
			ZomboWinBukkakeSection = (ZomboWinBukkakeSection + 1) % #bukkake_locations
			addPlayerWhiteText(player, formatBukkake(bukkake_locations[ZomboWinBukkakeSection + 1]))
		elseif rcontrol_key == key then
			playerTable = player:getTable()
			resetBukkake(playerTable)
			addPlayerBadText(player, "BUKKAKE RESETED!")
			checkBukkake(player)
		elseif switch_mode == key then
			playerTable = player:getTable()
			resetBukkake(playerTable)
			checkBukkake(player)

			ZomboWinBukkakeStatic = not ZomboWinBukkakeStatic

			addPlayerBadText(player, "STATIC MODE: DEACTIVATED")
			print("STATIC MODE:")
			print(ZomboWinBukkakeStatic)
		end
	end
end

---This function checks each value of the Bukkake and renders them accordingly. ONLY USED IN DYNAMIC!
---@param player: IsoPlayer
function checkBukkake(player)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end

	local semenLevels = playerTable.semenLevels

	for bodyPart, values in pairs(semenLevels) do
		local amount = values[1]
		local itemName = values[2]

		if amount > layersNum then amount = layersNum end --Limiting the amount we can use.

		--Adds C U M
		for i = 1, amount do
			if not player:getWornItem(string.format("Bukkake_%s%d", bodyPart, i)) then
				local bukkake = instanceItem(string.format("Bukkake_Addon.%s%d", itemName, i))
				player:setWornItem(bukkake:getBodyLocation(), bukkake)
			end
		end

		--Cleans body.
		for i = amount, layersNum - 1 do
			if i > layersNum - 1 then break end
			local bukkake = player:getWornItem(string.format("Bukkake_%s%d", bodyPart, i + 1))
			if bukkake then player:removeWornItem(bukkake) end
		end
	end
end
---Goes to the point, it cleans the player's body, and only shows one layer based on the index.
---	so if you wanted to display "Bukkake_Face1", put "Bukkake_Face" on the body_location with the
---	index 1. USED IN STATIC!
---Note: If the index is 0, it will just clean the player's body.
---@param player: IsoPlayer
---@param body_location: string; the location of the bukkake, like "Bukkake_Breast".
---@param index: number; the number of the Bukkake Layer to select.
function selectBukkake(player, body_location, index)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end

	local body_location = formatBukkake(body_location)
	local bukkake_slot = playerTable.semenLevels[body_location]

	--Removes every bukkake layer on the location given,
	for i = 1, layersNum do
		local bukkake = player:getWornItem(string.format("Bukkake_%s%d", body_location, i))
		if bukkake then player:removeWornItem(bukkake) end
	end

	if index <= 0 then return end
	local bukkake = instanceItem(string.format("Bukkake_Addon.%s%d", bukkake_slot[2], index))
	if not bukkake then 
		addPlayerBadText(player, "WASN'T POSSIBLE TO FIND BUKKAKE ITEM!")
		print("WASN'T POSSIBLE TO FIND BUKKAKE ITEM!")
	end
	player:setWornItem(bukkake:getBodyLocation(), bukkake)
end

---Prints out the Bukkake values unto the console.
---@param player: IsoPlayer
function printBukkake(player)
	local playerTable = player:getTable()
	for key, value in pairs(playerTable.semenLevels) do
		print(string.format("%s: %d %s", key, value[1], value[2]))
	end
end

---@param player: IsoPlayer
---@param location: string; the location of the value, currently 10 locations [back, breast, butt, chest, face, legs, misc, mouth, pussy, thigh]
---@param amount: number; Optional.
function addCum(player, location, amount)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end

	local location = formatBukkake(location)
	local quantity = playerTable.semenLevels[location][1]

	--Checks if an specific amount was inserted.
	if amount then
		quantity = quantity + amount
	else
		quantity = quantity + 1
	end
	
	if quantity > layersNum then quantity = layersNum end
	playerTable.semenLevels[location][1] = quantity
	checkBukkake(player)
end

---@param player: IsoPlayer
---@param location string: the location of the value, currently 10 locations [back, breast, butt, chest, face, legs, misc, mouth, pussy, thigh]
---@param amount: number
function removeCum(player, location, amount)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end

	local location = formatBukkake(location)
	local quantity = playerTable.semenLevels[location][1]

	if amount then
		quantity = quantity - amount
	else
		quantity = quantity - 1
	end
	--Complicated math that makes the value unable to go below 0.
	quantity = (quantity + (quantity * quantity) ^ 0.5) / 2
	playerTable.semenLevels[location][1] = quantity
	checkBukkake(player)
end

---@param player: IsoPlayer
---@param location string: the location of the value, currently 10 locations [back, breast, butt, chest, face, legs, misc, mouth, pussy, thigh]
---@param amount: number
function setCum(player, location, amount)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end

	local location = formatBukkake(location)
	local quantity = playerTable.semenLevels[location][1]

	quantity = amount
	if quantity > layersNum then 
		quantity = layersNum
	else
		quantity = (quantity + (quantity * quantity) ^ 0.5) / 2
	end

	playerTable.semenLevels[location][1] = quantity
	checkBukkake(player)
end

local function addBukkakeValues(playernum, player)
	local playerTable = player:getTable()
	if not playerTable.semenLevels then resetBukkake(playerTable) end
end

Events.OnKeyPressed.Add(testFunction)
Events.OnCreatePlayer.Add(addBukkakeValues)